const transformHook = (rw) => {    
    
    // Extract gallery property from node properties, setting an empty object as the default value if gallery doesn't exist
    const { gallery = {} } = rw.props

    // Extract the array of resources, setting an empty array as the defult
    const { resources = [] } = gallery

    // Loop over all resources, requesting a path to the resized resource
    const paths = resources.map((resource) => {
        // Return a path to the resized resource
        return rw.resizeResource(resource, 320);
    })

    // Create a hasImages, true if there are any resources, false otherwise
    const hasImages = paths.length > 0

    // Set hasImages and paths in the template data
    rw.setProps({
        hasImages,
        paths
    })
}

exports.transformHook = transformHook;
